/*
 * Decompiled with CFR 0.152.
 */
package com.endilcrafter.farmersplus.common.block.entity;

import com.endilcrafter.farmersplus.common.crafting.MillstoneRecipe;
import com.endilcrafter.farmersplus.common.registry.PlusAdvancements;
import com.endilcrafter.farmersplus.common.registry.PlusBlockEntities;
import com.endilcrafter.farmersplus.common.registry.PlusRecipeTypes;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.mixin.accessor.RecipeManagerAccessor;
import vectorwing.farmersdelight.common.utility.ItemUtils;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class MillstoneBlockEntity
extends SyncedBlockEntity {
    private final ItemStackHandler inventory = this.createHandler();
    private final LazyOptional<IItemHandler> inputHandler = LazyOptional.of(() -> this.inventory);
    private ResourceLocation lastRecipeID;

    public MillstoneBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PlusBlockEntities.MILLSTONE.get(), pos, state);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
    }

    public boolean processStoredItem(@Nullable Player player) {
        if (this.f_58857_ == null) {
            return false;
        }
        Optional<MillstoneRecipe> matchingRecipe = this.getMatchingRecipe(new RecipeWrapper((IItemHandlerModifiable)this.inventory), player);
        matchingRecipe.ifPresent(recipe -> {
            List<ItemStack> results = recipe.rollResults(this.f_58857_.f_46441_);
            for (ItemStack resultStack : results) {
                ItemUtils.spawnItemEntity((Level)this.f_58857_, (ItemStack)resultStack.m_41777_(), (double)((double)this.f_58858_.m_123341_() + 0.5), (double)((double)this.f_58858_.m_123342_() + 0.8), (double)((double)this.f_58858_.m_123343_() + 0.5), (double)0.0, (double)0.0, (double)0.0);
            }
            this.playProcessingSound(recipe.getSoundEventID(), this.getStoredItem());
            this.consumeItem();
            if (player instanceof ServerPlayer) {
                PlusAdvancements.MILLSTONE.trigger((ServerPlayer)player);
            }
        });
        return matchingRecipe.isPresent();
    }

    private Optional<MillstoneRecipe> getMatchingRecipe(RecipeWrapper recipeWrapper, @Nullable Player player) {
        Recipe recipe;
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        if (this.lastRecipeID != null && (recipe = (Recipe)((RecipeManagerAccessor)this.f_58857_.m_7465_()).getRecipeMap((RecipeType)PlusRecipeTypes.MILLING.get()).get(this.lastRecipeID)) instanceof MillstoneRecipe && recipe.m_5818_((Container)recipeWrapper, this.f_58857_)) {
            return Optional.of((MillstoneRecipe)recipe);
        }
        List recipeList = this.f_58857_.m_7465_().m_44056_((RecipeType)PlusRecipeTypes.MILLING.get(), (Container)recipeWrapper, this.f_58857_);
        if (recipeList.isEmpty()) {
            if (player != null) {
                player.m_5661_((Component)TextUtils.getTranslation((String)"block.millstone.invalid_item", (Object[])new Object[0]), true);
            }
            return Optional.empty();
        }
        Optional<MillstoneRecipe> recipe2 = recipeList.stream().findFirst();
        this.lastRecipeID = ((MillstoneRecipe)recipe2.get()).m_6423_();
        return recipe2;
    }

    public void playProcessingSound(String soundEventID, ItemStack boardItem) {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(soundEventID));
        if (sound != null) {
            this.playSound(sound, 1.0f, 1.0f);
        } else {
            Item var6 = boardItem.m_41720_();
            if (var6 instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)var6;
                Block block = blockItem.m_40614_();
                SoundType soundType = block.m_49966_().m_60827_();
                this.playSound(soundType.m_56775_(), 1.0f, 0.8f);
            } else {
                this.playSound(SoundEvents.f_12446_, 1.0f, 0.8f);
            }
        }
    }

    public void playSound(SoundEvent sound, float volume, float pitch) {
        if (this.f_58857_ != null) {
            this.f_58857_.m_6263_(null, (double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + 0.5f), (double)((float)this.f_58858_.m_123343_() + 0.5f), sound, SoundSource.BLOCKS, volume, pitch);
        }
    }

    public boolean addItem(ItemStack itemStack) {
        if (this.isEmpty() && !itemStack.m_41619_()) {
            this.inventory.setStackInSlot(0, itemStack.m_41620_(itemStack.m_41613_()));
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public ItemStack consumeItem() {
        if (!this.isEmpty()) {
            ItemStack item = this.getStoredItem().m_41620_(1);
            this.inventoryChanged();
            return item;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack removeItem() {
        if (!this.isEmpty()) {
            ItemStack item = this.getStoredItem().m_41620_(this.getStoredItem().m_41613_());
            this.inventoryChanged();
            return item;
        }
        return ItemStack.f_41583_;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public ItemStack getStoredItem() {
        return this.inventory.getStackInSlot(0);
    }

    public boolean isEmpty() {
        return this.inventory.getStackInSlot(0).m_41619_();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return cap.equals((Object)ForgeCapabilities.ITEM_HANDLER) ? this.inputHandler.cast() : super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        this.inputHandler.invalidate();
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(){

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                MillstoneBlockEntity.this.inventoryChanged();
            }
        };
    }
}

